<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Location extends Model 
{

    protected $table = 'locations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'address', 'city_id');

    public function skus()
    {
        return $this->belongsToMany('App\Models\Sku')->withTimestamps()->withPivot('quantity');
    }

    public function transactions()
    {
        return $this->hasMany('App\Models\Transaction');
    }

}